/*
*******************************************************************************
*
* File:         mailbox.h
* Description:  mailboxing and PCI Interface functions that have no handle 
* Author:       Henrik Liebau
* Created:      09 Sep 1999, 09:15:31
* Modified:     Wed Sep 15 15:28:19 1999 by Henrik Liebau, BVS R&D
* Language:     C/C++ Include File
* Package:	E2920A series CAPI
* Status:	Confidential (do not distribute publicly)       
*
* (C) Copyright 1999 by Hewlett-Packard GmbH, All Rights Reserved.
*
*******************************************************************************
*/
 
#ifndef __mailbox_h__
#define __mailbox_h__

#include <typedefs.h>

#ifdef __cplusplus
extern "C" {
#endif

/***************************************************************************
   CAUTION:
   This function is a special CLI command, because it doesn't take a handle,
   and therefore currently isn't handled by the perl scripts. 
   If you change the parameters of this function, don't forget to
   adapt the file manuacli.h, too.
***************************************************************************/
b_errtype EXPORT BestDevIdentifierGet(                        /* @diget  */
				      b_int32      vendor_id, /* @vendor */
				      b_int32      device_id, /* @dev    */
				      b_int32      number,    /* @n      */
				      b_int32      *devid     /* #RETURN "value=: %08lx\\h\n" */
				      );

b_errtype EXPORT  BestPCICfgMailboxSendRegWrite(
  b_int32      devid,
  b_int32      value,
  b_int32      *status
  );


b_errtype EXPORT  BestPCICfgMailboxReceiveRegRead(
  b_int32	devid,
  b_int32      *value,
  b_int32      *status
  );

#ifdef __cplusplus
}
#endif

#endif
